/*********************************************************
    Sync Sequenzer
  *********************************************************
  Wolfgang Spahn                          dernulleffekt.de
  04 April 2019

  *********************************************************/

// pin assignmet
int StepPin[8] =  {19, 13, 12, 9, 8, 1, 2, 0};  // pins for each step, Button & LED (19 = A5)

int CVPotiPin = A1;
int StepsPotiPin = A4;
int SpeedPotiPin = A3;
int CVInPin = A0;

int CV1OutPin = 5;
int CV2OutPin = 6;
int TriggerOutPin = 7;
int TriggerInPin = 11;

int TriggerSwitchPin = 10;
int ModeSwitchPin = 3;
int CVSwitchPin = 4;
int SpeedSwitchPin = 16;

// variables assignment
int CV1_Values[8] = {0, 0, 0, 0, 0, 0, 0, 0};                   // voltage output for CV 1
int CV2_Values[8] = {0, 0, 0, 0, 0, 0, 0, 0};                   // voltage output for CV 2
float CV_Groove[8] = {1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};  // length of each note
int TriggerLength[8] = {300, 300, 300, 300, 300, 300, 300, 300};

int CV1_Value;
int CV2_Value;
int CV_Value;
int Trigger_Value;
float Groove_Value;

int CV1_Out = 0;
int CV2_Out = 0;
int TriggerOut = 0;
int TriggerTime = 10230;
int TriggerCheck = 0;

int StepsPoti = 1023;
int Steps = 8;
int StepButton = 0;
int StepNumber = 0;
int CVIn = 0;
unsigned long DelayValue = 0;

int ModeSwitch = LOW;
int CVSwitch = LOW;
int SpeedSwitch = LOW;
int SpeedAmp = 0;
int BeatButton = 0;

int TriggerSwitch = LOW;
int TriggerIn = LOW;
int TriggerInCheck = LOW;

unsigned long previousMillis = 0;
unsigned long currentMillis = 0;
int LEDState = HIGH;

int verbose = 0;  // in verbose mode Step 6 is allways on!

void setup() {
  // sets the speed on pin 5 and 6 (just for a Atmega328 chip):
  TCCR0B = TCCR0B & 0b11111000 | 0x01;

  pinMode(CV1OutPin, OUTPUT);
  analogWrite(CV1OutPin, 0);
  pinMode(CV2OutPin, OUTPUT);
  analogWrite(CV2OutPin, 0);
  pinMode(TriggerOutPin, OUTPUT);
  digitalWrite(TriggerOutPin, LOW);

  pinMode(TriggerInPin, INPUT_PULLUP);
  pinMode(TriggerSwitchPin, INPUT_PULLUP);
  pinMode(ModeSwitchPin, INPUT_PULLUP);
  pinMode(CVSwitchPin, INPUT_PULLUP);
  pinMode(SpeedSwitchPin, INPUT_PULLUP);

  for (int i = 0; i < 8; i++) {
    pinMode(StepPin[i], OUTPUT);
  }
  TestLEDs();
  TriggerTest();
  for (int i = 0; i < 8; i++) {
    pinMode(StepPin[i], INPUT);
  }
  if (verbose > 0) {
    Serial.begin(9600);
    Serial.println("verbose mode is on");
  }

  previousMillis = millis();

}

void loop() {
  TriggerSwitch = digitalRead(TriggerSwitchPin);
  if (TriggerSwitch == LOW) {
    SelfTrigger();
  }
  if (TriggerSwitch == HIGH) {
    ExTrigger();
  }
}

void ExTriggerTest() {
  int test = digitalRead(TriggerInPin);
  digitalWrite(TriggerOutPin, test);
}



void ExTrigger() {
  for (int i = 0; i < Steps; i++) {
    LEDState = LOW;
    pinMode(StepPin[i], OUTPUT);
    digitalWrite(StepPin[i], LEDState);
    analogWrite(CV1OutPin, CV1_Values[i]);
    analogWrite(CV2OutPin, CV2_Values[i]);
    digitalWrite(TriggerOutPin, HIGH);
    TriggerCheck = 0;
    while (LEDState == LOW) {
      ButtonCheck(i);
      //ModeCheck();
      StepsPoti = analogRead(StepsPotiPin);
      Steps = map(StepsPoti, 0, 1023, 1, 8);

      TriggerTime = 10 * TriggerLength[i];
      currentMillis = millis();

      if ((currentMillis - previousMillis >= TriggerTime) && (TriggerCheck == 0)) {
        digitalWrite(TriggerOutPin, LOW);
        TriggerCheck = 1;
      }
      TriggerIn = digitalRead(TriggerInPin);

      if (TriggerIn == LOW) TriggerInCheck = 0;

      if ((TriggerIn == HIGH)  && (TriggerInCheck == 0)) {
        previousMillis = currentMillis;
        TriggerInCheck = 1;
        LEDState = HIGH;
        digitalWrite(StepPin[i], LEDState);
        pinMode(StepPin[i], INPUT);
        digitalWrite(TriggerOutPin, LOW);
      }
      TriggerSwitch = digitalRead(TriggerSwitchPin);
      if (TriggerSwitch == LOW) {
        LEDState = HIGH;
        digitalWrite(StepPin[i], LEDState);
        pinMode(StepPin[i], INPUT);
        digitalWrite(TriggerOutPin, LOW);
      }
    }
  }
}


void SelfTrigger() {
  if (Steps > 1) {
    for (int i = 0; i < Steps; i++) {
      LEDState = LOW;
      pinMode(StepPin[i], OUTPUT);
      digitalWrite(StepPin[i], LEDState);
      analogWrite(CV1OutPin, CV1_Values[i]);
      analogWrite(CV2OutPin, CV2_Values[i]);
      digitalWrite(TriggerOutPin, HIGH);
      TriggerCheck = 0;
      while (LEDState == LOW) {
        ButtonCheck(i);
        //ModeCheck();
        StepsPoti = analogRead(StepsPotiPin);
        Steps = map(StepsPoti, 0, 1023, 1, 8);


        SpeedSwitch = digitalRead(SpeedSwitchPin);
        if (SpeedSwitch == LOW) {
          DelayValue = analogRead(SpeedPotiPin);
          DelayValue = map(DelayValue, 1023, 0, 5, 100000);
        }
        else {
          CVIn = analogRead(CVInPin);
          DelayValue = map(CVIn, 1023, 0, 5, 100000);
        }
        DelayValue = DelayValue * CV_Groove[i];

        TriggerTime = 10 * TriggerLength[i];

        currentMillis = millis();

        if ((currentMillis - previousMillis >= TriggerTime) && (TriggerCheck == 0)) {
          digitalWrite(TriggerOutPin, LOW);
          TriggerCheck = 1;
        }
        if (currentMillis - previousMillis >= DelayValue) {
          previousMillis = currentMillis;
          LEDState = HIGH;
          digitalWrite(StepPin[i], LEDState);
          pinMode(StepPin[i], INPUT);
          digitalWrite(TriggerOutPin, LOW);
        }
      }
    }
  }
  if (Steps == 1) {

    SpeedSwitch = digitalRead(SpeedSwitchPin);
    if (SpeedSwitch == LOW) {
      StepNumber = analogRead(SpeedPotiPin);
    }
    else {
      StepNumber = analogRead(CVInPin);
    }
    if (StepNumber < 10) StepNumber = 0;
    StepNumber = map(StepNumber, 1023, 0, 7, 0);
    LEDState = LOW;
    pinMode(StepPin[StepNumber], OUTPUT);
    digitalWrite(StepPin[StepNumber], LEDState);
    analogWrite(CV1OutPin, CV1_Values[StepNumber]);
    analogWrite(CV2OutPin, CV2_Values[StepNumber]);
    ButtonCheck(StepNumber);
    //ModeCheck();
    StepsPoti = analogRead(StepsPotiPin);
    Steps = map(StepsPoti, 0, 1023, 1, 8);

    LEDState = HIGH;
    digitalWrite(StepPin[StepNumber], LEDState);
    pinMode(StepPin[StepNumber], INPUT);
  }
}

// checks if a button is pressed and assign the value for the CV
void ButtonCheck(int StepOn) {
  ModeSwitch = digitalRead(ModeSwitchPin);

  // change the CV
  if (ModeSwitch == LOW) {
    for (int j = 0; j < 8; j++) {
      if (j == StepOn) {
        pinMode(StepPin[j], INPUT);
        StepButton = digitalRead(StepPin[j]);
        pinMode(StepPin[j], OUTPUT);
        digitalWrite(StepPin[j], LOW);
      }
      else {
        StepButton = digitalRead(StepPin[j]);
      }
      if (StepButton == LOW) {
        // read and store the CV 1 and 2 values depending on the CV switch
        CV_Value = analogRead(CVPotiPin);
        if (CVSwitch == LOW) {
          CVSwitch = digitalRead(CVSwitchPin);
          CV1_Value = map(CV_Value, 0, 1023, 0, 255);
          CV1_Values[j] = CV1_Value;
        }
        else {
          CVSwitch = digitalRead(CVSwitchPin);
          CV2_Value = map(CV_Value, 0, 1023, 0, 255);
          CV2_Values[j] = CV2_Value;
        }
      }
    }
  }
  // change the beat
  if (ModeSwitch == HIGH) {
    for (int j = 0; j < 8; j++) {
      if (j == StepOn) {
        pinMode(StepPin[j], INPUT);
        BeatButton = digitalRead(StepPin[j]);
        pinMode(StepPin[j], OUTPUT);
        digitalWrite(StepPin[j], LOW);
      }
      else {
        BeatButton = digitalRead(StepPin[j]);
      }
      if (BeatButton == LOW) {
        // read and store the CV 1 and 2 values
        //Trigger_Value = analogRead(CV1PotiPin);
        Groove_Value = analogRead(CVPotiPin);
        Groove_Value = map(Groove_Value, 0, 1023, 200, 1800);
        float Groove_Value_float = Groove_Value / 1000;
        //TriggerLength[j] = Trigger_Value;
        CV_Groove[j] = Groove_Value_float;
      }
    }
  }
}



//********************************************************

// testing all LEDs
void TestLEDs() {
  for (int i = 0; i < 8; i++) {
    digitalWrite(StepPin[i], LOW);
  }
  delay(30000);
  for (int i = 0; i < 8; i++) {
    digitalWrite(StepPin[i], HIGH);
    delay(10000);
  }
}

// testing the Trigger
void TriggerTest() {
  digitalWrite(TriggerOutPin, HIGH);
  delay(10000);
  digitalWrite(TriggerOutPin, LOW);
}
