/* store and call the pattern to and from the EEPROM
*/


// check if the program button is pressed
void CheckProgramSwitch(){
  // check the store and call switch
  int CheckCallButton = digitalRead(CallButtonPin);
  if ((CheckCallButton == LOW) & (ActivationCallCheck == 1)) {
    ActivationCallCheck = 0;
    CallButton_State = 1;
    ButtonStop = 1;
  }
  if ((CheckCallButton == HIGH) & (ActivationCallCheck == 0)) {
    ActivationCallCheck = 1;
    CallButton_State = 0;
    ButtonStop = 0;
  }

  int CheckStoreButton = digitalRead(StoreButtonPin);
  if ((CheckStoreButton == LOW) & (ActivationStoreCheck == 1)) {
    ActivationStoreCheck = 0;
    StoreButton_State = 1;
    ButtonStop = 1;
  }
  if ((CheckStoreButton == HIGH) & (ActivationStoreCheck == 0)) {
    ActivationStoreCheck = 1;
    StoreButton_State = 0;
    ButtonStop = 0;
  }
  
  /*Serial.print("ActivationCallCheck - ");
  Serial.print(ActivationCallCheck);
  Serial.print("   CallButton_State - ");
  Serial.println(CallButton_State);*/
}


// start the calling and storing process when the program button was, and still is, pressed
void CallPattern() { 
  // checks witch button/programm place is selected by reading each button state
  for (int j = 0; j < 8; j++) {
    int StepButton = HIGH;
    if (j == ActiveStep) {               // in case of an active button it has to be switch in a reading state
      pinMode(StepPin[j], INPUT);
      StepButton = digitalRead(StepPin[j]);
      pinMode(StepPin[j], OUTPUT);       // ... and back
      digitalWrite(StepPin[j], LOW);
    }
    else {
      StepButton = digitalRead(StepPin[j]);
    }
    // if a certain button is pressed ...
    if (StepButton == LOW) {
      WhichButtonPressed = j;
      //Serial.print("WhichButtonPressed ="); Serial.println(WhichButtonPressed);

      call_pattern(1, 1, 1);   // call the programmed pattern
      CallButton_State = 0;
      return;
    }
  }
}

void StorePattern(){
// checks witch button/programm place is selected by reading each button state
  for (int j = 0; j < 8; j++) {
    int StepButton = HIGH;
    if (j == ActiveStep) {               // in case of an active button it has to be switch in a reading state
      pinMode(StepPin[j], INPUT);
      StepButton = digitalRead(StepPin[j]);
      pinMode(StepPin[j], OUTPUT);       // ... and back
      digitalWrite(StepPin[j], LOW);
    }
    else {
      StepButton = digitalRead(StepPin[j]);
    }
    // if a certain button is pressed ...
    if (StepButton == LOW) {
      WhichButtonPressed = j;
      //Serial.print("WhichButtonPressed ="); Serial.println(WhichButtonPressed);
 
      store_pattern(1, 1, 1); // store the programmed pattern
      StoreButton_State = 0;
      return;
    }
  }
}


// stores the pattern depending on the switches and the bank
void store_pattern(int CV1, int CV2, int B) {
  //store the values from 0 to
  if (CV1 == 1) {
    for (int i = 0; i < 8; i++) {
      EEPROMWriteInt(WhichButtonPressed * 8 + i, CV1_Values[i]);
    }
  }
  if (CV2 == 1) {
    for (int i = 0; i < 8; i++) {
      EEPROMWriteInt((64 + WhichButtonPressed * 8) + i, CV2_Values[i]);
    }
  }
  if (B == 1) {
    for (int i = 0; i < 8; i++) {
      EEPROMWriteInt((128 + WhichButtonPressed * 8) + i, B_Values[i]);
    }
  }
}

// calls the pattern depending on the switches and the bank
void call_pattern(int CV1, int CV2, int B) {
  if (CV1 == 1) {
    for (int i = 0; i < 8; i++) {
      CV1_Values[i] = EEPROMReadInt(WhichButtonPressed * 8 + i);
    }
  }
  if (CV2 == 1) {
    for (int i = 0; i < 8; i++) {
      CV2_Values[i] = EEPROMReadInt((64 + WhichButtonPressed * 8) + i);
    }
  }
  if (B == 1) {
    for (int i = 0; i < 8; i++) {
      B_Values[i] = EEPROMReadInt((128 + WhichButtonPressed * 8) + i);
    }
  }
}


// read and write one bytes
void EEPROMWriteInt(int address, int value) {
  EEPROM.update(address, value);
}

int EEPROMReadInt(int address) {
  int value = EEPROM.read(address);
  return value;
}


// read and write two bytes
void EEPROMWriteInt2b(int address, int value) {
  byte two = (value & 0xFF);
  byte one = ((value >> 8) & 0xFF);

  EEPROM.update(address, two);
  EEPROM.update(address + 1, one);
}

int EEPROMReadInt2b(int address) {
  long two = EEPROM.read(address);
  long one = EEPROM.read(address + 1);

  return ((two << 0) & 0xFFFFFF) + ((one << 8) & 0xFFFFFFFF);
}


//**** for development ********************************************************

// multiplex switch test
void multiplex_switches_test() {
  // detect which switches are on
  switch (MultiplexValue) {
    case 0:    // no switch
      switch_LED(0, 0, 0, 0);
      break;
    case 1:   // switch 1
      switch_LED(1, 0, 0, 0);
      break;
    case 2:   // switch 2
      switch_LED(0, 1, 0, 0);
      break;
    case 3:   // switch 1 & 2
      switch_LED(1, 1, 0, 0);
      break;
    case 4:   // switch 3
      switch_LED(0, 0, 1, 0);
      break;
    case 5:    // switch 1 & 3
      switch_LED(1, 0, 1, 0);
      break;
    case 6:    // switch 2 & 3
      switch_LED(0, 1, 1, 0);
      break;
    case 7:    // switch 1 & 2 & 3
      switch_LED(1, 1, 1, 0);
      break;
    case 8:   // switch 4
      switch_LED(0, 0, 0, 1);
      break;
    case 9:    // switch 1 & 4
      switch_LED(1, 0, 0, 1);
      break;
    case 10:    // switch 2 & 4
      switch_LED(0, 1, 0, 1);
      break;
    case 11:    // switch 1 & 2 & 4
      switch_LED(1, 1, 0, 1);
      break;
    case 12:    // switch 3 & 4
      switch_LED(0, 0, 1, 1);
      break;
    case 13:    // switch 1 & 3 & 4
      switch_LED(1, 0, 1, 1);
      break;
    case 14:    // switch 2 & 3 & 4
      switch_LED(0, 1, 1, 1);
      break;
    case 15:    // switch 1 & 2 & 3 & 4 &)
      switch_LED(1, 1, 1, 1);
      break;
    default:
      switch_LED(0, 0, 0, 0);
      break;
  }
}

void switch_LED(int LED1_state, int LED2_state, int LED3_state, int LED4_state) {
  for (int i = 0; i < 8; i++) {
    pinMode(StepPin[i], OUTPUT);
  }
  for (int i = 0; i < 8; i++) {
    digitalWrite(StepPin[i], HIGH);
  }
  digitalWrite(13, LED1_state);
  digitalWrite(12, LED2_state);
  digitalWrite(9, LED3_state);
  digitalWrite(8, LED4_state);
}
