
/****************************************************
   Paper-Bits Midi to CV

   dernulleffekt.de
   Wolfgang Spahn

   An Arduino Leonardo program for a MIDI to CV interface
      - 4 fast PWM on pin 5,6,9 and 10
        they response on Midi CC Number 1,2,3 and 4 on Channel 1
      - clock on pin 4

   To change the Midi Channels for the Notes change NoteChannel1 and 2
   and to change the Control Change Channel and Number change CCChannel and CCNumber
   To change the Midi Clock divider change ClockDivider
   and to change the length of the interval for the Clock Pin change ClockInterval

 *****************************************************/

// include the libraries:
#include <MIDIUSB.h>
#include <MIDI.h>

MIDI_CREATE_DEFAULT_INSTANCE();


byte NoteChannel1 = 1;     // Cannel Number (1-16) of Note & Velocity Nr 1
byte NoteChannel2 = 2;     // Cannel Number (1-16) of Note & Velocity Nr 2
byte CCChannel = 1;        // Control Cannel (1-16)
byte CCNumber1 = 1;         // Control Number (1-127)
byte CCNumber2 = 2;
byte CCNumber3 = 3;
byte CCNumber4 = 4;

int ClockInterval = 20;          // length of the pulse at the clock pin in milliseconds
int ClockDivider = 24;           // Midi Clock sends 24 times per quarter note
int ClockCounter = 0;            // counter for the Midi Clock
int ClockActiv = 0;

int Gate1Pin = 7;                // Pin of the Gate Nr 1
int Gate2Pin = 8;                // Pin of the Gate Nr 2
int MidiClockPin = 4;

unsigned long SwitchMillis = 100;  // the time when the clock pin is set high
unsigned long CurrentMillis = 0; // the actual time
int Verbose = 0;


void setup()
{
  pinMode(4, OUTPUT);
  pinMode(5, OUTPUT);
  pinMode(6, OUTPUT);
  pinMode(9, OUTPUT);
  pinMode(10, OUTPUT);
  MIDIsetup();
  PWMsetup();
  if (Verbose == 1) Serial.begin(9600);
  digitalWrite(4, HIGH);
  //delay(100);
  //digitalWrite(4,LOW);

}


void loop() {
  CheckClock();
  MIDI.read();
  MIDIoverUSB();
}

void MIDIoverUSB() {
  midiEventPacket_t rx;
  do {
    rx = MidiUSB.read();
    // Parse MIDI:
    // byte1 = Status Byte
    // byte2 = Data Byte 1
    // byte3 = Data Byte 2
    if (rx.byte1 >= 144 && rx.byte1 <= 159)         // Note ON (144 -159)
    {
      rx.byte1 = rx.byte1 - 143;                    // Channel 1 - 16 instead of 144 - 159
      if (rx.byte3 > 0)                         // vilocity 0 = Note OFF
      {
        handleNoteOn (rx.byte1, rx.byte2, rx.byte3);
      }
      else handleNoteOff (rx.byte1, rx.byte2, rx.byte3);
    }
    else if (rx.byte1 >= 128 && rx.byte1 <= 143)    // Note OFF (128 - 143)
    {
      rx.byte1 = rx.byte1 - 127;                    // Channel 1 - 16 instead of 128 - 143
      handleNoteOff (rx.byte1, rx.byte2, rx.byte3);
    }
    else if (rx.byte1 >= 176 && rx.byte1 <= 191)    // Control (176 - 191)
    {
      rx.byte1 = rx.byte1 - 175;                    // Channel 1 - 16 instead of 176 - 191
      handleControlChange (rx.byte1, rx.byte2, rx.byte3);
    }
    else if (rx.byte1 == 248)                  // MIDI Clock (248)
    {
      handleClock();
    }
    MidiUSB.flush();
  } while (rx.header != 0);
}
