#include <Wire.h>
#include "Adafruit_MCP23017.h"
#include <MIDI.h>

Adafruit_MCP23017 mcp1;
Adafruit_MCP23017 mcp2;
MIDI_CREATE_DEFAULT_INSTANCE();

int Velocity = 127;
int Channel = 1;
int Octave = 48; // octave 3

int KeyControl1[12] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
int KeyControl2[13] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
int NoteArray1[12] = {5, 1, 0, 3, 2, 4, 7, 6, 10, 11, 8, 9};
int NoteArray2[13] = {5, 1, 0, 3, 2, 4, 7, 6, 10, 11, 8, 9, 12 };

int NotePattern[8] = {2, 0, 5, 8, 9};
float DelayPattern[8] = {1, 1, 0.3, 0.7, 1, 1, 0.3, 0.7};

int KeyControlUp = 0;
int KeyControlDown = 0;
int KeyControlProgramUp = 0;
int KeyControlProgramDown = 0;
int Program = 0;
int DirectionProgram = 1;

void setup() {
  MIDI.begin(1);

  mcp1.begin(0);      // use default address 0  0x20
  mcp2.begin(1);      // use default address 1  0x21

  for (int i; i < 8; i++) {
    mcp1.pinMode(i, INPUT);
    mcp2.pinMode(i, INPUT);
  }
  pinMode(13, OUTPUT);  // use the p13 LED as debugging
  //Serial.begin(9600);
}


void loop() {
  OctaveButtonCheck();
  ProgramButtonCheck();
  if (mcp1.digitalRead(12) == 0) {
    KeyCheck();
  }
  else if (mcp1.digitalRead(12) == 1) {
    AutoRun();
  }
  //Serial.println (Program);
}

void ProgramButtonCheck() {
  if ((mcp2.digitalRead(13) == 1) && (KeyControlProgramUp == 0)) { //Up pressed
    if (Program < 5) {
      Program++;
    }
    else Program = 0;
    KeyControlProgramUp = 1;
  }
  if ((mcp2.digitalRead(13) == 0) && (KeyControlProgramUp == 1)) { //Up released
    KeyControlProgramUp = 0;
  }
  if ((mcp2.digitalRead(14) == 1) && (KeyControlProgramDown == 0)) { //Up pressed
    if (Program > 0) {
      Program--;
    }
    else Program = 5;
    KeyControlProgramDown = 1;
  }
  if ((mcp2.digitalRead(14) == 0) && (KeyControlProgramDown == 1)) { //Up released
    KeyControlProgramDown = 0;
  }
}

void OctaveButtonCheck() {
  if ((mcp1.digitalRead(13) == 1) && (KeyControlUp == 0)) { //Up pressed
    if (Octave < 96) {
      Octave = Octave + 12;
    }
    KeyControlUp = 1;
  }
  if ((mcp1.digitalRead(13) == 0) && (KeyControlUp == 1)) { //Up released
    KeyControlUp = 0;
  }
  if ((mcp1.digitalRead(14) == 1) && (KeyControlDown == 0)) { //Down pressed
    if (Octave > 23) {
      Octave = Octave - 12;
    }
    KeyControlDown = 1;
  }
  if ((mcp1.digitalRead(14) == 0) && (KeyControlDown == 1)) { //Down released
    KeyControlDown = 0;
  }
}

void KeyCheck() {
  // for MCP0
  for (int i = 0; i < 12; i++) {
    if ((mcp1.digitalRead(NoteArray1[i]) == 1) && (KeyControl1[i] == 0)) {
      PlayNote(i);
      KeyControl1[i] = 1;
      digitalWrite(13, HIGH);
    }
    if ((mcp1.digitalRead(NoteArray1[i]) == 0) && (KeyControl1[i] == 1)) {
      PlayNoteOff(i);
      KeyControl1[i] = 0;
      digitalWrite(13, LOW);
    }
  }
  // for MCP1
  for (int i = 0; i < 13; i++) {
    if ((mcp2.digitalRead(NoteArray2[i]) == 1) && (KeyControl2[i] == 0)) {
      PlayNote(i + 12);
      KeyControl2[i] = 1;
      digitalWrite(13, HIGH);
    }
    if ((mcp2.digitalRead(NoteArray2[i]) == 0) && (KeyControl2[i] == 1)) {
      PlayNoteOff(i + 12);
      KeyControl2[i] = 0;
      digitalWrite(13, LOW);
    }
  }
}

void AutoRun() {
  int RandomRandom = random(1023);
  int RandomGenerator = analogRead(A1);
  if (RandomRandom < RandomGenerator) {
    int ArrayIndex = random(0, 5);
    NotePattern[ArrayIndex] = random(0, 11);
  }
  for (int i = 0; i < 5; i++) {
    digitalWrite(13, HIGH);
    PlayNote(NotePattern[i]);
    int AutoDelay = analogRead(A0);
    int RandomDelay = random(100);
    delay((DelayPattern[i]*AutoDelay)+RandomDelay);
    digitalWrite(13, LOW);
    PlayNoteOff(NotePattern[i]);
  }
}


void PlayNote(int Note) {
  Velocity = analogRead(A1);
  if (Velocity == 0) Velocity = 1;

  if (Program == 0) {
    MIDI.sendNoteOn(Note + Octave, Velocity, Channel); // Send a Note (pitch 42, velo 127 on channel 1)
  }
  if (Program == 1) {
    MIDI.sendNoteOn(Note + Octave, Velocity, Channel); // Send a Note (pitch 42, velo 127 on channel 1)
    MIDI.sendNoteOn(Note + 4 + Octave, Velocity, Channel); // Send a Note (pitch 42, velo 127 on channel 1)
    MIDI.sendNoteOn(Note + 7 + Octave, Velocity, Channel); // Send a Note (pitch 42, velo 127 on channel 1)
  }
  if (Program == 2) {
    MIDI.sendNoteOn(Note + Octave, Velocity, Channel); // Send a Note (pitch 42, velo 127 on channel 1)
    MIDI.sendNoteOn(Note + 5 + Octave, Velocity, Channel); // Send a Note (pitch 42, velo 127 on channel 1)
    MIDI.sendNoteOn(Note + 8 + Octave, Velocity, Channel); // Send a Note (pitch 42, velo 127 on channel 1)
  }

  if (Program == 3) {
    int Delay = analogRead(A0) / 5 + 100;
    MIDI.sendNoteOn(Note + Octave, Velocity, Channel); // Send a Note (pitch 42, velo 127 on channel 1)
    delay(Delay + random(40));
    MIDI.sendNoteOff(Note + Octave, 0, Channel); // Stop the note
    MIDI.sendNoteOn(Note + 5 + Octave, Velocity, Channel); // Send a Note (pitch 42, velo 127 on channel 1)
    delay(Delay + random(40));
    MIDI.sendNoteOff(Note + 5 + Octave, 0, Channel); // Stop the note
    MIDI.sendNoteOn(Note + 8 + Octave, Velocity, Channel); // Send a Note (pitch 42, velo 127 on channel 1)
    delay(Delay + random(40));
    MIDI.sendNoteOff(Note + 8 + Octave, 0, Channel); // Stop the note
    MIDI.sendNoteOn(Note + 11 + Octave, Velocity, Channel); // Send a Note (pitch 42, velo 127 on channel 1)
    delay(Delay);
    MIDI.sendNoteOff(Note + 11 + Octave, 0, Channel); // Stop the note
  }
  if (Program == 4) {
    int Delay = analogRead(A0) / 5 + 100;
    MIDI.sendNoteOn(Note + Octave, Velocity, Channel); // Send a Note (pitch 42, velo 127 on channel 1)
    delay(Delay + random(40));
    MIDI.sendNoteOff(Note + Octave, 0, Channel); // Stop the note
    MIDI.sendNoteOn(Note + 3 + Octave, Velocity, Channel);
    delay(Delay + random(40));
    MIDI.sendNoteOff(Note + 3 + Octave, 0, Channel);
    MIDI.sendNoteOn(Note + 4 + Octave, Velocity, Channel);
    delay(Delay + random(40));
    MIDI.sendNoteOff(Note + 4 + Octave, 0, Channel);
    MIDI.sendNoteOn(Note - 4 + Octave, Velocity, Channel);
    delay(Delay + random(40));
    MIDI.sendNoteOff(Note - 4 + Octave, 0, Channel);
    MIDI.sendNoteOn(Note + 5 + Octave, Velocity, Channel);
    delay(Delay + random(40));
    MIDI.sendNoteOff(Note + 5 + Octave, 0, Channel);
    MIDI.sendNoteOn(Note + 8 + Octave, Velocity, Channel);
    delay(Delay + random(40));
    MIDI.sendNoteOff(Note + 8 + Octave, 0, Channel);
    MIDI.sendNoteOn(Note + Octave, Velocity, Channel);
    delay(Delay);
    MIDI.sendNoteOff(Note + Octave, 0, Channel);
  }
  if (Program == 5) {
    int Delay = analogRead(A0) / 5 + 100;
    MIDI.sendNoteOn(Note + Octave, Velocity, Channel); // Send a Note (pitch 42, velo 127 on channel 1)
    delay(Delay + random(40));
    MIDI.sendNoteOff(Note + Octave, 0, Channel); // Stop the note
    MIDI.sendNoteOn(Note - 1 + Octave, Velocity, Channel);
    delay(Delay + random(40));
    MIDI.sendNoteOff(Note - 1 + Octave, 0, Channel);
    MIDI.sendNoteOn(Note - 2 + Octave, Velocity, Channel);
    delay(Delay + random(40));
    MIDI.sendNoteOff(Note - 2 + Octave, 0, Channel);
    MIDI.sendNoteOn(Note - 3 + Octave, Velocity, Channel);
    delay(Delay + random(40));
    MIDI.sendNoteOff(Note - 3 + Octave, 0, Channel);
    MIDI.sendNoteOn(Note - 4 + Octave, Velocity, Channel);
    delay(Delay + random(40));
    MIDI.sendNoteOff(Note - 4 + Octave, 0, Channel);
    MIDI.sendNoteOn(Note - 7 + Octave, Velocity, Channel);
    delay(Delay + random(40));
    MIDI.sendNoteOff(Note - 7 + Octave, 0, Channel);
    MIDI.sendNoteOn(Note - 7 + Octave, Velocity, Channel);
    delay(Delay + random(40));
    MIDI.sendNoteOff(Note - 7 + Octave, 0, Channel);
    MIDI.sendNoteOn(Note - 9 + Octave, Velocity, Channel);
    delay(Delay + random(40));
    MIDI.sendNoteOff(Note - 9 + Octave, 0, Channel);
    MIDI.sendNoteOn(Note - 12 + Octave, Velocity, Channel);
    delay(Delay);
    MIDI.sendNoteOff(Note - 12 + Octave, 0, Channel);
  }
}

void PlayNoteOff(int Note) {
  if (Program == 0) {
    MIDI.sendNoteOff(Note + Octave, 0, Channel); // Stop the note
  }
  if (Program == 1) {
    MIDI.sendNoteOff(Note + Octave, 0, Channel); // Stop the note
    MIDI.sendNoteOff(Note + 4 + Octave, 0, Channel); // Stop the note
    MIDI.sendNoteOff(Note + 7 + Octave, 0, Channel); // Stop the note
  }
  if (Program == 2) {
    MIDI.sendNoteOff(Note + Octave, 0, Channel); // Stop the note
    MIDI.sendNoteOff(Note + 5 + Octave, 0, Channel); // Stop the note
    MIDI.sendNoteOff(Note + 8 + Octave, 0, Channel); // Stop the note
  }
  if (Program == 3) {
    MIDI.sendNoteOff(Note + Octave, 0, Channel); // Stop the note
    MIDI.sendNoteOff(Note + 5 + Octave, 0, Channel); // Stop the note
    MIDI.sendNoteOff(Note + 8 + Octave, 0, Channel); // Stop the note
    MIDI.sendNoteOff(Note + 11 + Octave, 0, Channel); // Stop the note
  }
}








