/*******************************************************************************************
 * LTC1452 - 12 Bit Digital Analog Converer
 * Wolfgang Spahn 15_June_2015
 * dernulleffekt.de
 *
 * sends a 12 bit value to a LTC1452 DAC chip
 * the first four bit of the first byte get lost
 * the refference of the LTC1452 is connected 2.5V so the output will be between 0 and 5 V
 ********************************************************************************************/


int latchPin = 10;   // Cip Select on the LTC1452
int clockPin = A0;  // Clock on the LTC1452
int dataPin = A1;   // Data In on the LTC1452

void setup() {
  //set pins to output
  pinMode(latchPin, OUTPUT);
  digitalWrite(latchPin, LOW);
  pinMode(clockPin, OUTPUT);
  pinMode(dataPin, OUTPUT);
}

void loop() {
  ShiftDAC(5000); // 5000 = 5Volt
}

void ShiftDAC (int value){
  value = map(value,0,5000,0,4095);   // map value to 12 bit (0 to 4095)
  
  int SecondaryByteMask = 0b000011111111;         // mask for isolating the last 8 bits of the 12 bit value
  byte PrimaryByte = value >> 8;                  // the value is a maximum of 12 Bit, it is shifted to the right by 8 bytes to get four zeros folowed by the first 4 bits
  byte SecondaryByte = value & SecondaryByteMask; // compares the 12 bit value to isolate the 8 last bits and reduce it to a single byte. 

  // impulse latchPin for start transmitting
  digitalWrite(latchPin, HIGH);
  digitalWrite(latchPin, LOW);
  // transmit two bytes
  shiftOut(dataPin, clockPin, MSBFIRST,PrimaryByte);// data2); 
  shiftOut(dataPin, clockPin, MSBFIRST,SecondaryByte); //data1);  

  // impulse latchPin for stop transmitting
  digitalWrite(latchPin, HIGH);
  digitalWrite(latchPin, LOW);
}

