/******************************************************************************************************
   Analog Multiplexer
 ******************************************************************************************************
   Wolfgang Spahn 11.Jan.2017

   first board - 8 poti:
     digital pins 2,3,4 and analog pin 2

   second board - 4 poti & 4 fader:
     digital pins 5,6,7 and analog pin 3

*******************************************************************************************************/

// 74XX4051 ADDRESS PINS board 1:
#define  SA0 2
#define  SA1 3
#define  SA2 4

// 74XX4051 ADDRESS PINS board 2:
#define  SB0 5
#define  SB1 6
#define  SB2 7

// 74XX4051 ANALOG PIN :
#define  ZA 2
#define  ZB 3

#define LEDpin 10

void setup() {
  // Control LED
  pinMode(LEDpin, OUTPUT);
  digitalWrite(LEDpin, HIGH);
  // Address Oins
  pinMode(SA0, OUTPUT);
  pinMode(SA1, OUTPUT);
  pinMode(SA2, OUTPUT);
  pinMode(SB0, OUTPUT);
  pinMode(SB1, OUTPUT);
  pinMode(SB2, OUTPUT);

  // Serial - use it just for testing
  Serial.begin(9600);
}

void loop () {
    ReadPotis();
}

void ReadPotis() {
  Serial.println("First Board:");
  // loop through all the addresses of the first board
  for ( byte i = 0; i < 8 ; i++ ) {
    // set the address
    digitalWrite(SA0, bitRead(i, 0) ); // Takes first bit from binary value
    digitalWrite(SA1, bitRead(i, 1) ); // Takes second bit from binary value
    digitalWrite(SA2, bitRead(i, 2) ); // Takes third bit from value

    // read the analog input
    int AnalogA = analogRead(ZA);

    // Print the result
    Serial.print("Analog Pin 2 - for ");
    Serial.print(bitRead(i, 2));
    Serial.print(bitRead(i, 1));
    Serial.print(bitRead(i, 0));
    Serial.print(" is ");
    //Serial.println(AnalogA);

    switch (i) {
      case 0:
        Serial.print("Fader 03  ");
        Serial.println(AnalogA);
        break;
      case 1:
        Serial.print("Fader 02  ");
        Serial.println(AnalogA);
        break;
      case 2:
        Serial.print("Fader 01  ");
        Serial.println(AnalogA);
        break;
      case 3:
        Serial.print("Fader 04  ");
        Serial.println(AnalogA);
        break;
      case 4:
        Serial.print("Fader 05  ");
        Serial.println(AnalogA);
        break;
      case 5:
        Serial.print("Fader 08  ");
        Serial.println(AnalogA);
        break;
      case 6:
        Serial.print("Fader 06  ");
        Serial.println(AnalogA);
        break;
      case 7:
        Serial.print("Fader 07  ");
        Serial.println(AnalogA);
        break;
    }
    delay(100);
  }
  
  Serial.println("Second Board:");
  // loop through all the addresses of the second board
  for ( byte j = 0; j < 8 ; j++ ) {
    // set the address
    digitalWrite(SB0, bitRead(j, 0) ); // Takes first bit from binary value
    digitalWrite(SB1, bitRead(j, 1) ); // Takes second bit from binary value
    digitalWrite(SB2, bitRead(j, 2) ); // Takes third bit from value

    // read the analog input
    int AnalogB = analogRead(ZB);

    // Print the result
    Serial.print("Analog Pin 3 - for ");
    Serial.print(bitRead(j, 2));
    Serial.print(bitRead(j, 1));
    Serial.print(bitRead(j, 0));
    Serial.print(" is ");

    switch (j) {
      case 0:
        Serial.print("Fader 11  ");
        Serial.println(AnalogB);
        break;
      case 1:
        Serial.print("Fader 10  ");
        Serial.println(AnalogB);
        break;
      case 2:
        Serial.print("Fader 09  ");
        Serial.println(AnalogB);
        break;
      case 3:
        Serial.print("Fader 12  ");
        Serial.println(AnalogB);
        break;
      case 4:
        Serial.print("Fader 13  ");
        Serial.println(1023 - AnalogB);
        break;
      case 5:
        Serial.print("Fader 16  ");
        Serial.println(1023 - AnalogB);
        break;
      case 6:
        Serial.print("Fader 14  ");
        Serial.println(1023 - AnalogB);
        break;
      case 7:
        Serial.print("Fader 15  ");
        Serial.println(1023 - AnalogB);
        break;
    }
    delay(100);
  }

}
