/************************************************
    Waveplayer8 - Control

    A controller for two Waveplayer over RS232.
    It playes random files and pauses
    depending on a potentiometer.


    by Wolfgang Spahn
    02 Okt 2018

    dernulleffekt.de


 ************************************************/


#include <SoftwareSerial.h>

SoftwareSerial serial1(10, 11); // RX, TX
SoftwareSerial serial2(5, 6); // RX, TX

int play_led = 12;
int pause_led = 13;
int poti_pin = A7;
unsigned long pause = 0;
unsigned long longest_pause = 100; // seconds

int verbose = 0;

int number_of_tracks = 8;  // number of all tracks
int track_number = 1;      // number of track that will be played
unsigned long length_of_tracks[] = {11, 12, 13, 14, 15, 16, 17, 18}; // length of tracks in seconds
unsigned long play_length = 11;  // length of track 1 in seconds
byte play_track[] = {134, 255, 1, 01, 0, 0};   // command for playing track number 1

byte CRC = 0;


void setup() {
  pinMode(play_led, OUTPUT);
  pinMode(pause_led, OUTPUT);
  digitalWrite(play_led, LOW);
  digitalWrite(pause_led, LOW);

  randomSeed(analogRead(0));

  if (verbose == 1) {
    Serial.begin(9600);
    while (!Serial) {
      ;
    }
    Serial.println("Waveplayer8 - Control");
  }
  // set the data rate for the SoftwareSerial port
  serial1.begin(9600);
  serial2.begin(9600);
  delay(100);

}

void loop() {
  // read length of pause
  pause = analogRead(poti_pin);
  pause = map(pause,  0, 1023, longest_pause, 0);
  // choose track
  track_number = random(8) + 1;
  play_track[3] = track_number;
  // length of play
  play_length = length_of_tracks[track_number - 1];
  // check CRC
  byte CRC = crc_8(play_track, 6);


  if (verbose == 1) {
    Serial.print("Track Nr = ");
    Serial.print(track_number);
    Serial.print("\t");
    Serial.print("Play Length = ");
    Serial.print(play_length);
    Serial.print(" sec");
    Serial.print("\t");
    Serial.print("Pause = ");
    Serial.print(pause);
    Serial.print(" sec");
    Serial.print("\t");
    Serial.print("CRC = ");
    Serial.println(CRC);
  }

  for (int i = 0; i < 5; i++) {
    serial2.write((byte)play_track[i]);
  }
  serial2.write((byte)CRC);

  for (int i = 0; i < 5; i++) {
    serial1.write((byte)play_track[i]);
  }
  serial1.write((byte)CRC);

  digitalWrite(play_led, HIGH);
  delay(play_length * 1000);
  digitalWrite(play_led, LOW);
  digitalWrite(pause_led, HIGH);
  delay(pause * 1000);
  digitalWrite(pause_led, LOW);

}

