/* ******************************************************
 *  A Scetch to Map 4 Switches Build with an R-2R Ladder
 * ******************************************************
 *
 * https://paperpcb.dernulleffekt.de/doku.php?id=arduino_boards:multiplex_switches
 * 
 * Wolfgang Spahn - March 2020
 * dernulleffekt.de
*/


int my_value;
int my_switch;

int LED1 = 13;
int LED2 = 2;
int LED3 = 3;
int LED4 = 4;

void setup() {
  pinMode(LED1, OUTPUT);
  pinMode(LED2, OUTPUT);
  pinMode(LED3, OUTPUT);
  pinMode(LED4, OUTPUT);

  digitalWrite(LED1, HIGH);
  digitalWrite(LED2, HIGH);
  digitalWrite(LED3, HIGH);
  digitalWrite(LED4, HIGH);
  delay(1000);
  digitalWrite(LED1, LOW);
  delay(300);
  digitalWrite(LED2, LOW);
  delay(300);
  digitalWrite(LED3, LOW);
  delay(300);
  digitalWrite(LED4, LOW);
  delay(300);
  Serial.begin(9600);
}

void loop() {
  my_value = analogRead(A0);
  Serial.print("my_value = ");
  Serial.print(my_value);
  my_switch = map(my_value, -32, 991, 0, 16); 
  // The mapping function didn't spread all numbers equally.
  // To change that the range is shifted by 32 numbers to the left (1024 / 16 = 64) 
  Serial.print(" my_switch = ");
  Serial.println(my_switch);

  // detect which switches are on
  switch (my_switch) {
    case 0:    // no switch
      switch_LED(0, 0, 0, 0);
      break;
    case 1:   // switch 1
      switch_LED(1, 0, 0, 0);
      break;
    case 2:   // switch 2
      switch_LED(0, 1, 0, 0);
      break;
    case 3:   // switch 1 & 2
      switch_LED(1, 1, 0, 0);
      break;
    case 4:   // switch 3
      switch_LED(0, 0, 1, 0);
      break;
    case 5:    // switch 1 & 3
      switch_LED(1, 0, 1, 0);
      break;
    case 6:    // switch 2 & 3
      switch_LED(0, 1, 1, 0);
      break;
    case 7:    // switch 1 & 2 & 3
      switch_LED(1, 1, 1, 0);
      break;
    case 8:   // switch 4
      switch_LED(0, 0, 0, 1);
      break;
    case 9:    // switch 1 & 4
      switch_LED(1, 0, 0, 1);
      break;
    case 10:    // switch 2 & 4
      switch_LED(0, 1, 0, 1);
      break;
    case 11:    // switch 1 & 2 & 4
      switch_LED(1, 1, 0, 1);
      break;
    case 12:    // switch 3 & 4
      switch_LED(0, 0, 1, 1);
      break;
    case 13:    // switch 1 & 3 & 4
      switch_LED(1, 0, 1, 1);
      break;
    case 14:    // switch 2 & 3 & 4
      switch_LED(0, 1, 1, 1);
      break;
    case 15:    // switch 1 & 2 & 3 & 4 &)
      switch_LED(1, 1, 1, 1);
      break;
    default:
      switch_LED(0, 0, 0, 0);
      break;
  }
  delay(100);
}

void switch_LED(int LED1_state, int LED2_state, int LED3_state, int LED4_state) {
  digitalWrite(LED1, LED1_state);
  digitalWrite(LED2, LED2_state);
  digitalWrite(LED3, LED3_state);
  digitalWrite(LED4, LED4_state);
}
