/******************************************************************
 * MIDI to Servo
 ******************************************************************
 * by Wolfgang Spahn
 * 23mai2016
 *
 * Controlles up to 6 servo motor by MIDI controll messages
 *
 *****************************************************************/

#include <MIDI.h>
MIDI_CREATE_DEFAULT_INSTANCE();
#include <Servo.h>

Servo Servo1;
Servo Servo2;
Servo Servo3;
Servo Servo4;
Servo Servo5;
Servo Servo6;

int Position1 = 0;
int Position2 = 0;
int Position3 = 0;
int Position4 = 0;
int Position5 = 0;
int Position6 = 0;

////SETUP///////////////////////////////////////////////////////////

void setup()
{
  pinMode(10,OUTPUT);
  digitalWrite(10,HIGH);
  
  Servo1.attach(4);
  Servo2.attach(5);
  Servo3.attach(6);
  Servo4.attach(7);
  Servo5.attach(8);
  Servo6.attach(9);
  // Connect the handler functions to the library,
  // so it is called upon reception of a NoteOn.
  MIDI.setHandleNoteOn(handleNoteOn);
  MIDI.setHandleNoteOff(handleNoteOff);
  MIDI.setHandleControlChange(handleControlChange);
  MIDI.setHandleClock(handleClock);
  // Initiate MIDI communications, listen to all channels
  MIDI.begin(MIDI_CHANNEL_OMNI);
}

////MAIN LOOP///////////////////////////////////////////////////////

void loop()
{
  MIDI.read();
  while (MIDIUSB.available() > 0) { // Repeat while notes are available to read.
    MIDIEvent e;
    e = MIDIUSB.read();
    if (e.type > 175 || e.type < 192) {
      handleControlChange (e.m1, e.m2, e.m3);
    }
    MIDIUSB.flush();
  }
}


////MIDI HANDLER////////////////////////////////////////////////////

void handleNoteOn(byte channel, byte pitch, byte velocity)
{
}

void handleNoteOff(byte channel, byte pitch, byte velocity)
{

}

void handleControlChange (byte channel, byte number, byte value)
{
  //digitalWrite(10, LOW);
  switch (number) {              // nach dem Notenwert unterscheiden
    case 22:                                // bei Controller 22
      Position1 = value;
      Position1 = map(Position1, 0, 127, 0, 180);
      Servo1.write(Position1);
      break;
    case 23:                                // bei Controller 23
      Position2 = value;
      Position2 = map(Position2, 0, 127, 0, 180);
      Servo2.write(Position2);
      break;
    case 24:                                // bei Controller 24
      Position3 = value;
      Position3 = map(Position3, 0, 127, 0, 180);
      Servo3.write(Position3);
      break;
    case 25:                                // bei Controller 25
      Position4 = value;
      Position4 = map(Position4, 0, 127, 0, 180);
      Servo4.write(Position4);
      break;
    case 26:                                // bei Controller 26
      Position5 = value;
      Position5 = map(Position5, 0, 127, 0, 180);
      Servo5.write(Position5);
      break;
    case 27:                                // bei Controller 27
      Position5 = value;
      Position5 = map(Position5, 0, 127, 0, 180);
      Servo6.write(Position5);
      break;
  }
  //digitalWrite(10, HIGH);
}

void handleClock (void)
{
}


