/******************************************************************
 * MIDI to fast PWM
 ******************************************************************
 * by Wolfgang Spahn
 * 23mai2016
 *
 * Controlles up to 4 fast PWM outputs by MIDI controll messages
 * possible outputs are pin 5,6,9 and 10
 *
 *****************************************************************/

#include <MIDI.h>
MIDI_CREATE_DEFAULT_INSTANCE();

int Speed1 = 0;
int Speed2 = 0;
int Speed3 = 0;
int Speed4 = 0;

////SETUP///////////////////////////////////////////////////////////

void setup()
{ 
  // Connect the handler functions to the library,
  // so it is called upon reception of a NoteOn.
  MIDI.setHandleNoteOn(handleNoteOn);
  MIDI.setHandleNoteOff(handleNoteOff);
  MIDI.setHandleControlChange(handleControlChange);
  MIDI.setHandleClock(handleClock);
  // Initiate MIDI communications, listen to all channels
  MIDI.begin(MIDI_CHANNEL_OMNI);
  
  PWMsetup();
}

////MAIN LOOP///////////////////////////////////////////////////////

void loop()
{
  MIDI.read();
  while (MIDIUSB.available() > 0) { // Repeat while notes are available to read.
    MIDIEvent e;
    e = MIDIUSB.read();
    if (e.type > 175 || e.type < 192) {
      handleControlChange (e.m1, e.m2, e.m3);
    }
    MIDIUSB.flush();
  }
}


////MIDI HANDLER////////////////////////////////////////////////////

void handleNoteOn(byte channel, byte pitch, byte velocity)
{
}

void handleNoteOff(byte channel, byte pitch, byte velocity)
{

}

void handleControlChange (byte channel, byte number, byte value)
{
  //digitalWrite(10, LOW);
  switch (number) {              // nach dem Notenwert unterscheiden
    case 22:                                // bei Controller 22
      Speed1 = value;
      Speed1 = map(Speed1, 0, 127, 0, 255);
      setPWM5(Speed1);
      break;
    case 23:                                // bei Controller 23
      Speed2 = value;
      Speed2 = map(Speed2, 0, 127, 0, 255);
      setPWM6(Speed2);
      break;
    case 24:                                // bei Controller 24
      Speed3 = value;
      Speed3 = map(Speed3, 0, 127, 0, 255);
      setPWM9(Speed3);
      break;
    case 25:                                // bei Controller 25
      Speed4 = value;
      Speed4 = map(Speed4, 0, 127, 0, 255);
      setPWM10(Speed4);
      break;
  }
  //digitalWrite(10, HIGH);
}

void handleClock (void)
{
}


