/* 

   ==========================================================================================================
   MIDI-Steuerung
   von Wolfgang Spahn 07_2011
   ==========================================================================================================

 
   Auslesen von Midi Daten am RX-Eingang und Schalten von 6 PWM-Ausgaenge
 
   ==========================================================================================================
    ACHTUNG:
    Midi-Kabel beim Starten ausgesteckt lassen,
    da der Bootloader sonst glaubt, ein neues Programm wird geladen.
    Absturzgefahr, neu programierung ist manchmal no:tig.
    Oder den Midi-In Eingang (bzw. den Eingangsoptokoppler) erst nach dem Booten mit Strom versorgen
   ==========================================================================================================
 
 
Grundlegendes u:ber das MIDI Protokoll:
  MIDI Signale bestehen aus zwei, oder drei Byte. Sie fangen mit einem Status Byte an (Werte von 128 bis 255,
  es ko:nnen ein oder zwei Datenbyte (Werte von 0 bis 127) folgen.
 
  Beispiel:
  
  144-36-100
   - Das Statusbyte "144":  "144" steht fu:r "Note-An" am Kanal 1.
     144 = "Kanal 1/On" bis 159 = "Kanal 16/On".
   - In diesem Fall ist das zweite Byte der Notenwert (36 = mittleres C) .
     0 = "C der -1ten Oktave" bis 127 = "G der 9te Oktave".
   - Das dritte Byte ist die Anschlagsdynamik der Note bzw. wie stark die Taste gedru:ckt wurde.
     (0 bis 127, in diesem Fall 100 )
   
  128-36
   - Das ist eine "Note aus" Signale (Statusbyte = 128).
     128 = "Kanal 1/Off" bis 143 = "Kanal 16/OFF".
   - Gefolgt vom Notenwert (DatenByte = 36)
     Da das "Note aus" Signal keine Dynamik braucht, gibt es nur zwei Byte
     Anmerkung: einige Keyboards senden keine "Note aus" Signale, statt dessen nur ein "Note an" mit null Dynamik
     d.h. das Signal ko:nnte so aussehen: 144-36-0
     
   176-1-100
   - Das ist ein Control/Mode Change Signal, a:nderung des Contollers (Statusbyte = 176)
     176 = Kanal 1 bis 191 = Kanal 16
   - Dies entspricht der Nummer des Contollers (in diesem Fall Contoller 1)
   - Das dritte Byte entspricht dem Wert (0 bis 127, in diesem Fall 100 )
     
     =========================================================================================================
 */



//Definition der Variablen
int gMidiSignal[3] = {0, 0, 0}; // Tabelle fu:r das Midi Signal, (Statusbyte, Datenbyte1, Datenbyte2) 
                                //  oder (Status mit Kanal, Note, Dynamik)
int gStatus  = 0;               // Statuswerte um festzulegen welches Byte gerade empfangen wurde: 
                                // 0 = kein Statusbyte im Speicher
                                // 1 = StatusByte und kein Datenbyte im Speicher
                                // 2 = StatusByte und ein Datenbyte im Speicher
                                // 3 = StatusByte und zwei Datenbyte im Speicher                          
int gWert = 0;                  // Zwischenspeicher fu:r den Wert am Seriellen Einganges (0 bis 255)

int gKontrollLed = 13;          // Auswahl des Pins fu:r die Kontroll LED
int gMidiPower = 7;             // Auswahl des Pins fu:r die Stromversorgung des Midi In Moduls

int gAusgang1 = 3;              // Auswahl des Pins fu:r den PWM-Ausgang-01
int gAusgang2 = 5;              // Auswahl des Pins fu:r den PWM-Ausgang-02
int gAusgang3 = 6;              // ...
int gAusgang4 = 9;
int gAusgang5 = 10;
int gAusgang6 = 11;

int gDynamik = 0;               // Wert 1 des PWM Ausgangs in Abhaengigkeit der Dynamik

//****************************************************************************************************************************** 

//Ein- und Ausga:nge definieren und den Serialport konfigurieren
void setup() {
  pinMode(gKontrollLed,OUTPUT);        // Status LED Pin als Ausgang festlegen
  pinMode(gMidiPower,OUTPUT);          // Stromversorgungs Pin des Midi-Einganges als Ausgang festlegen
  
  pinMode(gAusgang1, OUTPUT);          // PWM Pin als Ausgang festlegen
  analogWrite(gAusgang1, gDynamik);            // PWM Ausgang auf 0 setzen 
  pinMode(gAusgang2, OUTPUT);          // PWM Pin als Ausgang festlegen
  analogWrite(gAusgang2, gDynamik);            // PWM Ausgang auf 0 setzen
  pinMode(gAusgang3, OUTPUT);          // PWM Pin als Ausgang festlegen
  analogWrite(gAusgang3, gDynamik);            // PWM Ausgang auf 0 setzen
  pinMode(gAusgang4, OUTPUT);          // PWM Pin als Ausgang festlegen
  analogWrite(gAusgang4, gDynamik);            // PWM Ausgang auf 0 setzen
  pinMode(gAusgang5, OUTPUT);          // PWM Pin als Ausgang festlegen
  analogWrite(gAusgang5, gDynamik);            // PWM Ausgang auf 0 setzen
  pinMode(gAusgang6, OUTPUT);          // PWM Pin als Ausgang festlegen
  analogWrite(gAusgang6, gDynamik);            // PWM Ausgang auf 0 setzen
  
  Serial.begin(31250);              //Baud Rate fu;r die serielle Kommunikation auf 31250 Baud (Bits in der Sekunde) festlegen    
  digitalWrite(gKontrollLed, HIGH); // Kontoll LED anschalten
  digitalWrite(gMidiPower, HIGH);   // Stromversorgung fu:r Midi-Eingang anschalten
}
//****************************************************************************************************************************

// HauptSchleife: 
void loop () {
  Auslesen ();
  Schalten ();
  }
    
//**************************************************************************************************************************** 
 
 /* Auslesen der MIDI Daten und Fallpru:fung:

   - Pru:fen ob serielle Daten im Zwischenspeicher sind und diese zwischenspeichern.
   - Unterscheidung der mo:glichen Fa:lle:
   
       Am Eingang liegt eine Signal an, und ...
           ein Statusbyte wird empfangen und ...
       1.    der Zwischenspeicher ist leer                                                --> Byte speichern und gStatus = 1 setzen
       2.    es liegt ein Statusbyte mit einem Datenbyte im Zwischenspeicher              --> Speicher Lo:schen. dann Byte speichern und gStatus = 1 setzen
           ein Datenbyte wird empfangen und ...
       3.    der Zwischenspeicher ist leer                                                --> Ignorieren
       4.    es liegt ein Statusbyte mit keinem oder einem Datenbyte im Zwischenspeicher  --> Byte speichern und gStatus = 2 oder 3 setzen
             
       Am Eingang liegt kein Signal an                                                    --> Auslesen wiederholen
       
       Bei "Note aus" (Statuswert 128 bis 143) wird nie auf ein zweites Datenbyte gewartet sondern dies einfach erga:nst.
      
   Hierbei wird die Tabelle mit den Midi Werten jedesmal u:berschrieben. 
 */
 
void Auslesen () {
  if (Serial.available() > 0) {                              // Pru:fen ob Daten am seriellen Einngang vorhanden sind
    gWert = Serial.read();                                   // Lesen des seriellen Einganges und speichern des Wertes in gWert

    if ((gWert >= 176) && (gWert <= 191))  {                                       // Pru:fen ob das Byte ein Statusbyte ist (Werte Zwischen 128 und 255) 
     StatusSpeichern ();                                     // und dann speichern
    }
    else if (gWert < 128){                                   // Pru:fen ob das Byte ein Datenbyte ist (Werte zwischen 0 und 127) 
    DatenSpeichern ();
    }
  }
 }

// Ablegen und Speicher der Midi Werte in einer Tabelle

void StatusSpeichern () {
  gMidiSignal[0] = gWert;                          // Speichern des Wertes am ersten Tabellenplatz
  gMidiSignal[1] = 0;                              // Den zweiten Tabellenplatz auf 0
  gMidiSignal[2] = 0;                              // Den dritten Tabellenplatz auf 0
  gStatus  = 1;                                    // Status Wert auf 1 setzen
 }

 void DatenSpeichern () {
  switch (gStatus) {                                // gStatus Pru:fen
    case 0:
     gMidiSignal[2] = gWert;                        // Speichern des Wertes am dritten Tabellenplatz
     gStatus  = 3;                                  // Status Wert auf 3 setzen
     break; 
    case 1:                                         // Fall 2: StatusByte vorhanden und noch kein Datenbyte im Speicher
     gMidiSignal[1] = gWert;                        // Speichern des Wertes am zweiten Tabellenplatz
     gStatus  = 2;                                  // Status Wert auf 2 setzen
     break;    
    case 2:                                         // Fall 4: StatusByte vorhanden und bereits ein Datenbyte im Speicher
     gMidiSignal[2] = gWert;                        // Speichern des Wertes am dritten Tabellenplatz
     gStatus  = 3;                                  // Status Wert auf 3 setzen
     break;
  }
  if ((gMidiSignal[0] >= 128) && (gMidiSignal[0] <= 143) && (gStatus == 2)) {  // Pru:fen ob ein "Note aus" Signal vorliegt
     gMidiSignal[2] = 0;                                                       // Speichern des Wertes 0 am dritten Tabellenplatz
     gStatus  = 3;                                                             // Status Wert auf 3 setzen
  }
 }

 
 
//******************************************************************************************************************************
 
/* Anschalten der Ausga:nge in Abha:ngigkeit der Mididaten 
   aber nur wenn ein Kompletes Signal eingegangen ist.
*/

void Schalten(){   
 if (gStatus == 3) {                             // Pru:fen ob ein vollsta:ndiges Midi Signal vorliegt
    gDynamik = gMidiSignal[2] * 2;               // PWM werte liegen zwischen 0 und 255
    switch (gMidiSignal[1]) {                    // nach dem Notenwert unterscheiden
    case 1:                                     // bei Note C-1  
      analogWrite(gAusgang1,gDynamik);     // Ausgang 1 mit entsprechender Dynamik schalten
      break;
    case 2:                                     // bei Note C#-1
      analogWrite(gAusgang2,gDynamik);     // Ausgang 1 mit entsprechender Dynamik schalten
      break;
    case 3:                                     // bei Note D-1
      analogWrite(gAusgang3,gDynamik);     // Ausgang 1 mit entsprechender Dynamik schalten
      break;
    case 4:                                     // bei Note 
      analogWrite(gAusgang4,gDynamik);     // Ausgang 1 mit entsprechender Dynamik schalten
      break;
    case 5:                                     // bei Note 
      analogWrite(gAusgang5,gDynamik);     // Ausgang 1 mit entsprechender Dynamik schalten
      break;  
    case 6:                                     // bei Note 
      analogWrite(gAusgang6,gDynamik);     // Ausgang 1 mit entsprechender Dynamik schalten
      break;
    }
    gStatus  = 0;                                  // Status Wert auf 0 setzen
  }
 }
 
 // Lo:schen des Zwischenspeichers
 void SpeicherLehren () {
   gMidiSignal[0] = 0;                            // Speichern des Wertes 0 am ersten Tabellenplatz
   gMidiSignal[1] = 0;                            // Speichern des Wertes 0 am zweiten Tabellenplatz
   gMidiSignal[2] = 0;                            // Speichern des Wertes 0 am dritten Tabellenplatz
   gStatus  = 0;                                  // Status Wert auf 0 setzen
   }
 

//*************************************************************************************************************************

// Blinken zum Testen
  void Blinken(){
  digitalWrite(gKontrollLed, LOW);
  delay(200);
  digitalWrite(gKontrollLed, HIGH);
  delay(200);
}
//******************************************************************************************************************************************************  

