/* 

   ==========================================================================================================
   MIDI-Steuerung
   von Wolfgang Spahn 07_2011
   ==========================================================================================================

 
   Auslesen von Midi Daten am RX-Eingang
   und Schalten von 4 Motorcontrolern, mit jeweils 1 PWM- und 2 digitalen Ausga:ngen.
 
   ==========================================================================================================
    ACHTUNG:
    Midi-Kabel beim Starten ausgesteckt lassen,
    da der Bootloader sonst glaubt, ein neues Programm wird geladen.
    Absturzgefahr, neu programierung ist manchmal no:tig.
    Oder den Midi-In Eingang (bzw. den Eingangsoptokoppler) erst nach dem Booten mit Strom versorgen
   ==========================================================================================================
 
 
Grundlegendes u:ber das MIDI Protokoll:
  MIDI Signale bestehen aus zwei, oder drei Byte. Sie fangen mit einem Status Byte an (Werte von 128 bis 255,
  es ko:nnen ein oder zwei Datenbyte (Werte von 0 bis 127) folgen.
 
  Beispiel:
  
  144-36-100
   - Das Statusbyte "144":  "144" steht fu:r "Note-An" am Kanal 1.
     144 = "Kanal 1/On" bis 159 = "Kanal 16/On".
   - In diesem Fall ist das zweite Byte der Notenwert (36 = mittleres C) .
     0 = "C der -1ten Oktave" bis 127 = "G der 9te Oktave".
   - Das dritte Byte ist die Anschlagsdynamik der Note bzw. wie stark die Taste gedru:ckt wurde.
     (0 bis 127, in diesem Fall 100 )
   
  128-36
   - Das ist eine "Note aus" Signale (Statusbyte = 128).
     128 = "Kanal 1/Off" bis 143 = "Kanal 16/OFF".
   - Gefolgt vom Notenwert (DatenByte = 36)
     Da das "Note aus" Signal keine Dynamik braucht, gibt es nur zwei Byte
     Anmerkung: einige Keyboards senden keine "Note aus" Signale, statt dessen nur ein "Note an" mit null Dynamik
     d.h. das Signal ko:nnte so aussehen: 144-36-0
     
   176-1-100
   - Das ist ein Control/Mode Change Signal, A:nderung des Contollers (Statusbyte = 176)
     176 = Kanal 1 bis 191 = Kanal 16
   - Dies entspricht der Nummer des Contollers (in diesem Fall Contoller 1)
   - Das dritte Byte entspricht dem Wert (0 bis 127, in diesem Fall 100 )
   Es ko:nnen danach auch nur noch weitere Bytes (ohne Status und Contollernummer) gesendet werden
     
     =========================================================================================================
 */



//Definition der Variablen
int gMidiSignal[3] = {0, 0, 0}; // Tabelle fu:r das Midi Signal, (Statusbyte, Datenbyte1, Datenbyte2) 
                                //  oder (Status mit Kanal, Note, Dynamik)
int gStatus  = 0;               // Statuswerte um festzulegen welches Byte gerade empfangen wurde: 
                                // 0 = kein Statusbyte im Speicher
                                // 1 = StatusByte und kein Datenbyte im Speicher
                                // 2 = StatusByte und ein Datenbyte im Speicher
                                // 3 = StatusByte und zwei Datenbyte im Speicher                          
int gWert = 0;                  // Zwischenspeicher fu:r den Wert am Seriellen Einganges (0 bis 255)

int gMidiPower = 1;             // Auswahl des Pins fu:r die Stromversorgung des Midi In Moduls
//
// ACHTUNG! Zum Programieren PIN 1 ziehen!
//
int gMotor1 = 3;              // Auswahl des Pins fu:r den PWM-Ausgang-01
int gMotor2 = 5;              // Auswahl des Pins fu:r den PWM-Ausgang-02
int gMotor3 = 10;              // Auswahl des Pins fu:r den PWM-Ausgang-03
int gMotor4 = 11;              // Auswahl des Pins fu:r den PWM-Ausgang-04

int gRichtung1A = 4;//1;              // ...
int gRichtung1B = 2;
int gRichtung2A = 7;
int gRichtung2B = 6;
int gRichtung3A = 8;              // ...
int gRichtung3B = 9;
int gRichtung4A = 13;
int gRichtung4B = 12;

int gUmschalten1A = LOW;
int gUmschalten1B = HIGH;
int gUmschalten2A = LOW;
int gUmschalten2B = HIGH;
int gUmschalten3A = LOW;
int gUmschalten3B = HIGH;
int gUmschalten4A = LOW;
int gUmschalten4B = HIGH;

int gIntervall1A = 0;
int gIntervall1B = 0;
int gIntervall1C = 0;
int gIntervall2A = 0;
int gIntervall2B = 0;
int gIntervall2C = 0;
int gIntervall3A = 0;
int gIntervall3B = 0;
int gIntervall3C = 0;
int gIntervall4A = 0;
int gIntervall4B = 0;
int gIntervall4C = 0;

unsigned long gZeitpunkt1 = 0;
unsigned long gZeitpunkt1C = 0;
unsigned long gZeitpunkt2 = 0;
unsigned long gZeitpunkt2C = 0;
unsigned long gZeitpunkt3 = 0;
unsigned long gZeitpunkt3C = 0;
unsigned long gZeitpunkt4 = 0;
unsigned long gZeitpunkt4C = 0;
unsigned long gAktuelleZeit = 0;

int gWechsler1 = 1;
int gWechsler2 = 1;
int gWechsler3 = 1;
int gWechsler4 = 1;
int gPause1 = 0;
int gPause2 = 0;
int gPause3 = 0;
int gPause4 = 0;

int gDynamik1 = 0;               // Wert 1 des PWM Ausgangs in Abhaengigkeit der Dynamik
int gDynamik2 = 0;               // Wert 1 des PWM Ausgangs in Abhaengigkeit der Dynamik
int gDynamik3 = 0;               // Wert 1 des PWM Ausgangs in Abhaengigkeit der Dynamik
int gDynamik4 = 0;               // Wert 1 des PWM Ausgangs in Abhaengigkeit der Dynamik

//****************************************************************************************************************************** 

//Ein- und Ausga:nge definieren und den Serialport konfigurieren
void setup() {
  //pinMode(gKontrollLed,OUTPUT);        // Status LED Pin als Ausgang festlegen
  pinMode(gMidiPower,OUTPUT);          // Stromversorgungs Pin des Midi-Einganges als Ausgang festlegen
  
  pinMode(gMotor1, OUTPUT);          // PWM Pin als Ausgang festlegen
  analogWrite(gMotor1, gDynamik1);   // PWM Ausgang auf 0 setzen 
  pinMode(gMotor2, OUTPUT);          // PWM Pin als Ausgang festlegen
  analogWrite(gMotor2, gDynamik2);   // PWM Ausgang auf 0 setzen
  pinMode(gMotor3, OUTPUT);          // PWM Pin als Ausgang festlegen
  analogWrite(gMotor3, gDynamik3);   // PWM Ausgang auf 0 setzen
  pinMode(gMotor4, OUTPUT);          // PWM Pin als Ausgang festlegen
  analogWrite(gMotor4, gDynamik4);   // PWM Ausgang auf 0 setzen
  
  pinMode(gRichtung1A,OUTPUT);        // Richtungs Pin als Ausgang festlegen
  pinMode(gRichtung1B,OUTPUT);        // Richtungs Pin als Ausgang festlegen
  pinMode(gRichtung2A,OUTPUT);        // Richtungs Pin als Ausgang festlegen
  pinMode(gRichtung2B,OUTPUT);        // Richtungs Pin als Ausgang festlegen
  pinMode(gRichtung3A,OUTPUT);        // Richtungs Pin als Ausgang festlegen
  pinMode(gRichtung3B,OUTPUT);        // Richtungs Pin als Ausgang festlegen
  pinMode(gRichtung4A,OUTPUT);        // Richtungs Pin als Ausgang festlegen
  pinMode(gRichtung4B,OUTPUT);        // Richtungs Pin als Ausgang festlegen
  
  Serial.begin(31250);              //Baud Rate fu;r die serielle Kommunikation auf 31250 Baud (Bits in der Sekunde) festlegen    
  //digitalWrite(gKontrollLed, HIGH); // Kontoll LED anschalten
  digitalWrite(gMidiPower, HIGH);   // Stromversorgung fu:r Midi-Eingang anschalten
  
  digitalWrite(gRichtung1A, gUmschalten1A);
  digitalWrite(gRichtung1B, gUmschalten1B);
  digitalWrite(gRichtung2A, gUmschalten2A);
  digitalWrite(gRichtung2B, gUmschalten2B);
  digitalWrite(gRichtung3A, gUmschalten3A);
  digitalWrite(gRichtung3B, gUmschalten3B);
  digitalWrite(gRichtung4A, gUmschalten4A);
  digitalWrite(gRichtung4B, gUmschalten4B);
}
//****************************************************************************************************************************

// HauptSchleife: 
void loop () {
  Auslesen ();
  Schalten ();
  }
    
//**************************************************************************************************************************** 

 /* Auslesen der MIDI Contol Daten und Fallpru:fung:

   - Pru:fen ob serielle Daten im Zwischenspeicher sind und diese dann zwischenspeichern.
   - Unterscheidung der mo:glichen Fa:lle:
   
       Am Eingang liegt eine Signal an, und ...
           ein Statusbyte wird empfangen und ...
       1.    der Zwischenspeicher ist leer                                                --> Byte speichern und gStatus = 1 setzen
       2.    es liegt ein Statusbyte mit einem Datenbyte im Zwischenspeicher              --> Speicher Lo:schen. dann Byte speichern und gStatus = 1 setzen
           ein Datenbyte wird empfangen und ...
       3.    es liegt ein Statusbyte mit keinem oder einem Datenbyte im Zwischenspeicher  --> Byte speichern und gStatus = 2 oder 3 setzen
       4.    der Zwischenspeicher ist bereits voll                                        --> Byte an dritter Stelle speichern und gStatus auf 3 setzen     
       Am Eingang liegt kein Signal an                                                    --> Auslesen wiederholen
       
       Bei "Note aus" (Statuswert 128 bis 143) wird nie auf ein zweites Datenbyte gewartet sondern dies einfach erga:nst.
      
   Hierbei wird die Tabelle mit den Midi Werten jedesmal u:berschrieben. 
 */
 
void Auslesen () {
  if (Serial.available() > 0) {                              // Pru:fen ob Daten am seriellen Einngang vorhanden sind
    gWert = Serial.read();                                   // Lesen des seriellen Einganges und speichern des Wertes in gWert
    
    if ((gWert >= 176) && (gWert <= 191))  {                 // Pru:fen ob das Byte ein Controller-Statusbyte ist (Werte Zwischen 176 und 191) 
    StatusSpeichern ();                                     // und dann speichern
    }
    else if (gWert < 128){                                   // Pru:fen ob das Byte ein Datenbyte ist (Werte zwischen 0 und 127) 
    DatenSpeichern ();
    }
  }
 }


// Speichern eines Statusbytes (Fall 1)
void StatusSpeichern () {
  gMidiSignal[0] = gWert;                          // Speichern des Wertes am ersten Tabellenplatz
  gMidiSignal[1] = 0;                              // Den zweiten Tabellenplatz auf 0
  gMidiSignal[2] = 0;                              // Den dritten Tabellenplatz auf 0
  gStatus  = 1;                                    // Status Wert auf 1 setzen
 }

//Speichern eines Datenbytes (Fall 2, 3 und 4)
 void DatenSpeichern () {
  switch (gStatus) {                                // gStatus Pru:fen
    case 0:                                         // Fall 4: Zwischenspeicher bereits voll (Contol Change)
     gMidiSignal[2] = gWert;                        // Speichern des Wertes am dritten Tabellenplatz
     gStatus  = 3;                                  // Status Wert auf 3 setzen
     break; 
    case 1:                                         // Fall 2: StatusByte vorhanden und noch kein Datenbyte im Speicher
     gMidiSignal[1] = gWert;                        // Speichern des Wertes am zweiten Tabellenplatz
     gStatus  = 2;                                  // Status Wert auf 2 setzen
     break;    
    case 2:                                         // Fall 3: StatusByte vorhanden und bereits ein Datenbyte im Speicher
     gMidiSignal[2] = gWert;                        // Speichern des Wertes am dritten Tabellenplatz
     gStatus  = 3;                                  // Status Wert auf 3 setzen
     break;
  }
 }

 
//******************************************************************************************************************************
 
// Wenn ein Kompletes Signal eingegangen ist (gStatus = 3), Anschalten der Ausga:nge in Abha:ngigkeit der Mididaten 

void Schalten(){   
 if (gStatus == 3) {                       // Pru:fen ob ein vollsta:ndiges Midi Signal vorliegt
    switch (gMidiSignal[1]) {              // nach dem Notenwert unterscheiden
    // Motorgeschwingigkeit 1 bis 4 
    case 5:                                // bei Controller 1  
      gDynamik1 = gMidiSignal[2] * 2;         // PWM Werte liegen zwischen 0 und 255 die Midi Dynamik zwischen 0 und 127
      analogWrite(gMotor1,gDynamik1);     // Ausgang 1 mit entsprechender Dynamik schalten
      break;
    case 6:                                // bei Controller 2
      gDynamik2 = gMidiSignal[2] * 2;         // PWM Werte liegen zwischen 0 und 255 die Midi Dynamik zwischen 0 und 127  
      analogWrite(gMotor2,gDynamik2);     // Ausgang 2 mit entsprechender Dynamik schalten
      break;
    case 7:                                // bei Controller 1  
      gDynamik3 = gMidiSignal[2] * 2;         // PWM Werte liegen zwischen 0 und 255 die Midi Dynamik zwischen 0 und 127
      analogWrite(gMotor3,gDynamik3);     // Ausgang 1 mit entsprechender Dynamik schalten
      break;
    case 8:                                // bei Controller 2
      gDynamik4 = gMidiSignal[2] * 2;         // PWM Werte liegen zwischen 0 und 255 die Midi Dynamik zwischen 0 und 127  
      analogWrite(gMotor4,gDynamik4);     // Ausgang 2 mit entsprechender Dynamik schalten
      break;
    // Umschalten Motor 1   
    case 14:
      if (gMidiSignal[2] > 0) {
      gIntervall1A = 1270 - (gMidiSignal[2] * 10);
      }
      else {
      gIntervall1A = 0;  
      }
    break; 
    case 22:
      if (gMidiSignal[2] > 0) {
      gIntervall1B = 1270 - (gMidiSignal[2] * 10);
      }
      else {
      gIntervall1B = 0;  
      }
    break;
    case 30:
      if (gMidiSignal[2] > 0) {
      gIntervall1C = 1270 - (gMidiSignal[2] * 10);
      }
      else {
      gIntervall1C = 0;
      analogWrite(gMotor1,gDynamik1);
      }
    break;
     // Umschalten Motor 2   
    case 15:
      if (gMidiSignal[2] > 0) {
      gIntervall2A = 1270 - (gMidiSignal[2] * 10);
      }
      else {
      gIntervall2A = 0;  
      }
    break; 
    case 23:
      if (gMidiSignal[2] > 0) {
      gIntervall2B = 1270 - (gMidiSignal[2] * 10);
      }
      else {
      gIntervall2B = 0;  
      }
    break;
    case 31:
      if (gMidiSignal[2] > 0) {
      gIntervall2C = 1270 - (gMidiSignal[2] * 10);
      }
      else {
      gIntervall2C = 0;
      analogWrite(gMotor1,gDynamik2);
      }
    break;      
    // Umschalten Motor 3   
    case 16:
      if (gMidiSignal[2] > 0) {
      gIntervall3A = 1270 - (gMidiSignal[2] * 10);
      }
      else {
      gIntervall3A = 0;  
      }
    break; 
    case 24:
      if (gMidiSignal[2] > 0) {
      gIntervall3B = 1270 - (gMidiSignal[2] * 10);
      }
      else {
      gIntervall3B = 0;  
      }
    break;
    case 32:
      if (gMidiSignal[2] > 0) {
      gIntervall3C = 1270 - (gMidiSignal[2] * 10);
      }
      else {
      gIntervall3C = 0;
      analogWrite(gMotor3,gDynamik3);
      }
    break;
     // Umschalten Motor 4   
    case 17:
      if (gMidiSignal[2] > 0) {
      gIntervall4A = 1270 - (gMidiSignal[2] * 10);
      }
      else {
      gIntervall4A = 0;  
      }
    break; 
    case 25:
      if (gMidiSignal[2] > 0) {
      gIntervall4B = 1270 - (gMidiSignal[2] * 10);
      }
      else {
      gIntervall4B = 0;  
      }
    break;
    case 33:
      if (gMidiSignal[2] > 0) {
      gIntervall4C = 1270 - (gMidiSignal[2] * 10);
      }
      else {
      gIntervall4C = 0;
      analogWrite(gMotor4,gDynamik4);
      }
    break;
    }
    gStatus  = 0;                          // Status Wert auf 0 setzen
  }
  
  gAktuelleZeit = millis();
  
  // Intervallschalten Motor 1
  if ((gIntervall1A > 1) && (gIntervall1B == 0)) {
    if (gAktuelleZeit - gZeitpunkt1 > gIntervall1A) {
      gZeitpunkt1 = gAktuelleZeit;
      RichtungsWechsel1();
    }
  }
  if ((gIntervall1B > 1) && (gIntervall1A == 0)) {
    if (gAktuelleZeit - gZeitpunkt1 > gIntervall1B) {
      gZeitpunkt1 = gAktuelleZeit;
      RichtungsWechsel1();
    }
  }
  if ((gIntervall1B > 1) && (gIntervall1A > 0)) {
    if (gWechsler1 == 1) {
      if (gAktuelleZeit - gZeitpunkt1 > gIntervall1A) {
        gZeitpunkt1 = gAktuelleZeit;
        RichtungsWechsel1();
        gWechsler1 = 0;
      }
    }
    else {
      if (gAktuelleZeit - gZeitpunkt1 > gIntervall1B) {
        gZeitpunkt1 = gAktuelleZeit;
        RichtungsWechsel1(); 
        gWechsler1 = 1; 
      }
    }
  }
  if (gIntervall1C > 1) {
    if (gAktuelleZeit - gZeitpunkt1C > gIntervall1C) {
      gZeitpunkt1C = gAktuelleZeit;
      Pause1();
    }
  }
  // Intervallschalten Motor 2
  if ((gIntervall2A > 1) && (gIntervall2B == 0)) {
    if (gAktuelleZeit - gZeitpunkt2 > gIntervall2A) {
      gZeitpunkt2 = gAktuelleZeit;
      RichtungsWechsel2();
    }
  }
  if ((gIntervall2B > 1) && (gIntervall2A == 0)) {
    if (gAktuelleZeit - gZeitpunkt2 > gIntervall2B) {
      gZeitpunkt2 = gAktuelleZeit;
      RichtungsWechsel2();
    }
  }
  if ((gIntervall2B > 1) && (gIntervall2A > 0)) {
    if (gWechsler2 == 1) {
      if (gAktuelleZeit - gZeitpunkt2 > gIntervall2A) {
        gZeitpunkt2 = gAktuelleZeit;
        RichtungsWechsel2();
        gWechsler2 = 0;
      }
    }
    else {
      if (gAktuelleZeit - gZeitpunkt2 > gIntervall2B) {
        gZeitpunkt2 = gAktuelleZeit;
        RichtungsWechsel2(); 
        gWechsler2 = 1; 
      }
    }
  }
  if (gIntervall2C > 1) {
    if (gAktuelleZeit - gZeitpunkt2C > gIntervall2C) {
      gZeitpunkt2C = gAktuelleZeit;
      Pause2();
    }
  }
  // Intervallschalten Motor 3
  if ((gIntervall3A > 1) && (gIntervall3B == 0)) {
    if (gAktuelleZeit - gZeitpunkt3 > gIntervall3A) {
      gZeitpunkt3 = gAktuelleZeit;
      RichtungsWechsel3();
    }
  }
  if ((gIntervall3B > 1) && (gIntervall3A == 0)) {
    if (gAktuelleZeit - gZeitpunkt3 > gIntervall3B) {
      gZeitpunkt3 = gAktuelleZeit;
      RichtungsWechsel3();
    }
  }
  if ((gIntervall3B > 1) && (gIntervall3A > 0)) {
    if (gWechsler3 == 1) {
      if (gAktuelleZeit - gZeitpunkt3 > gIntervall3A) {
        gZeitpunkt3 = gAktuelleZeit;
        RichtungsWechsel3();
        gWechsler3 = 0;
      }
    }
    else {
      if (gAktuelleZeit - gZeitpunkt3 > gIntervall3B) {
        gZeitpunkt3 = gAktuelleZeit;
        RichtungsWechsel3(); 
        gWechsler3 = 1; 
      }
    }
  }
  if (gIntervall3C > 1) {
    if (gAktuelleZeit - gZeitpunkt3C > gIntervall3C) {
      gZeitpunkt3C = gAktuelleZeit;
      Pause3();
    }
  }
  // Intervallschalten Motor 4
  if ((gIntervall4A > 1) && (gIntervall4B == 0)) {
    if (gAktuelleZeit - gZeitpunkt4 > gIntervall4A) {
      gZeitpunkt4 = gAktuelleZeit;
      RichtungsWechsel4();
    }
  }
  if ((gIntervall4B > 1) && (gIntervall4A == 0)) {
    if (gAktuelleZeit - gZeitpunkt4 > gIntervall4B) {
      gZeitpunkt4 = gAktuelleZeit;
      RichtungsWechsel4();
    }
  }
  if ((gIntervall4B > 1) && (gIntervall4A > 0)) {
    if (gWechsler4 == 1) {
      if (gAktuelleZeit - gZeitpunkt4 > gIntervall4A) {
        gZeitpunkt4 = gAktuelleZeit;
        RichtungsWechsel4();
        gWechsler4 = 0;
      }
    }
    else {
      if (gAktuelleZeit - gZeitpunkt4 > gIntervall4B) {
        gZeitpunkt4 = gAktuelleZeit;
        RichtungsWechsel4(); 
        gWechsler4 = 1; 
      }
    }
  }
  if (gIntervall4C > 1) {
    if (gAktuelleZeit - gZeitpunkt4C > gIntervall4C) {
      gZeitpunkt4C = gAktuelleZeit;
      Pause4();
    }
  } 
  
 }
 
//******************************************************************************************************************************************************  

void RichtungsWechsel1() {
  if (gUmschalten1A == LOW) {
     gUmschalten1A = HIGH;
     gUmschalten1B = LOW;
    }
    else {
     gUmschalten1A = LOW;
     gUmschalten1B = HIGH; 
    }
  digitalWrite(gRichtung1A, gUmschalten1A);
  digitalWrite(gRichtung1B, gUmschalten1B);
}

void RichtungsWechsel2() {
  if (gUmschalten2A == LOW) {
     gUmschalten2A = HIGH;
     gUmschalten2B = LOW;
    }
    else {
     gUmschalten2A = LOW;
     gUmschalten2B = HIGH; 
    }
  digitalWrite(gRichtung2A, gUmschalten2A);
  digitalWrite(gRichtung2B, gUmschalten2B);
}

void RichtungsWechsel3() {
  if (gUmschalten3A == LOW) {
     gUmschalten3A = HIGH;
     gUmschalten3B = LOW;
    }
    else {
     gUmschalten3A = LOW;
     gUmschalten3B = HIGH; 
    }
  digitalWrite(gRichtung3A, gUmschalten3A);
  digitalWrite(gRichtung3B, gUmschalten3B);
}

void RichtungsWechsel4() {
  if (gUmschalten4A == LOW) {
     gUmschalten4A = HIGH;
     gUmschalten4B = LOW;
    }
    else {
     gUmschalten4A = LOW;
     gUmschalten4B = HIGH; 
    }
  digitalWrite(gRichtung4A, gUmschalten4A);
  digitalWrite(gRichtung4B, gUmschalten4B);
}


void Pause1(){
  if (gPause1 == 1){
    analogWrite(gMotor1,0);
    gPause1 = 0;
  }
  else {
    analogWrite(gMotor1,gDynamik1);
    gPause1 = 1;
  }
}

void Pause2(){
  if (gPause2 == 1){
    analogWrite(gMotor2,0);
    gPause2 = 0;
  }
  else {
    analogWrite(gMotor2,gDynamik2);
    gPause2 = 1;
  }
}

void Pause3(){
  if (gPause3 == 1){
    analogWrite(gMotor3,0);
    gPause3 = 0;
  }
  else {
    analogWrite(gMotor3,gDynamik3);
    gPause3 = 1;
  }
}

void Pause4(){
  if (gPause4 == 1){
    analogWrite(gMotor4,0);
    gPause4 = 0;
  }
  else {
    analogWrite(gMotor4,gDynamik4);
    gPause4 = 1;
  }
}

//****************************************************************************************************************************************************** 
  
